<?php

namespace MSML\AMF;

use Exception;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Client\PendingRequest;
use App\Http\Middleware\Client\AmfMiddleware;

class AMF
{
    /**
     * The client instance.
     */
    protected PendingRequest $client;

    /**
     * Create the client instance.
     */
    public function __construct()
    {
        $this->ensureNoConfigValuesAreMissing();
    }

    /**
     * Get the base AMF HTTP Client.
     */
    public static function getBaseClient(): PendingRequest
    {
        return Http::withToken(config('services.amf.api_key'))
            ->withMiddleware(AmfMiddleware::mapRequest())
            ->withMiddleware(AmfMiddleware::mapResponse())
            ->withOptions(['base_uri' => config('services.amf.uri')]);
    }

    /**
     * Throw a descriptive exception if a required configuration value is missing.
     */
    private function ensureNoConfigValuesAreMissing(): void
    {
        $configKeys = [
            'services.amf.api_key',
            'services.amf.uri',
        ];

        collect($configKeys)
            ->each(function ($key) {
                if (!config($key)) {
                    throw new Exception(sprintf('Missing required config value: `%s`', $key));
                }
            });
    }
}
