<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ArrayOfAccount implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\Account
     */
    private $Account;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Account' => $this->Account,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\Account $Account
     */
    public function __construct($Account)
    {
        $this->Account = $Account;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Account
     */
    public function getAccount()
    {
        return $this->Account;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Account $Account
     * @return ArrayOfAccount
     */
    public function withAccount($Account)
    {
        $new = clone $this;
        $new->Account = $Account;

        return $new;
    }
}
