<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetBasicDataResult implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfBaseDataResult
     */
    private $DeliveryCustomers;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'DeliveryCustomers' => $this->DeliveryCustomers,
            'ErrorMessage'      => $this->ErrorMessage,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\ArrayOfBaseDataResult $DeliveryCustomers
     * @var string $ErrorMessage
     */
    public function __construct($DeliveryCustomers, $ErrorMessage)
    {
        $this->DeliveryCustomers = $DeliveryCustomers;
        $this->ErrorMessage = $ErrorMessage;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfBaseDataResult
     */
    public function getDeliveryCustomers()
    {
        return $this->DeliveryCustomers;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfBaseDataResult $DeliveryCustomers
     * @return GetBasicDataResult
     */
    public function withDeliveryCustomers($DeliveryCustomers)
    {
        $new = clone $this;
        $new->DeliveryCustomers = $DeliveryCustomers;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetBasicDataResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }
}
