<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetOrderHistoryQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var \DateTime
     */
    private $EarliestHistoryDate;

    /**
     * @var string
     */
    private $LanguageCode;

    /**
     * @var int
     */
    private $NumberOfPeriods;

    /**
     * @var string
     */
    private $OldCustomerNumber;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode'        => $this->CustomerCode,
            'Division'            => $this->Division,
            'EarliestHistoryDate' => $this->EarliestHistoryDate,
            'LanguageCode'        => $this->LanguageCode,
            'NumberOfPeriods'     => $this->NumberOfPeriods,
            'OldCustomerNumber'   => $this->OldCustomerNumber,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var string $Division
     * @var \DateTime $EarliestHistoryDate
     * @var string $LanguageCode
     * @var int $NumberOfPeriods
     * @var string $OldCustomerNumber
     */
    public function __construct($CustomerCode, $Division, $EarliestHistoryDate, $LanguageCode, $NumberOfPeriods, $OldCustomerNumber)
    {
        $this->CustomerCode = $CustomerCode;
        $this->Division = $Division;
        $this->EarliestHistoryDate = $EarliestHistoryDate;
        $this->LanguageCode = $LanguageCode;
        $this->NumberOfPeriods = $NumberOfPeriods;
        $this->OldCustomerNumber = $OldCustomerNumber;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetOrderHistoryQuery
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return GetOrderHistoryQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return \DateTime
     */
    public function getEarliestHistoryDate()
    {
        return $this->EarliestHistoryDate;
    }

    /**
     * @param \DateTime $EarliestHistoryDate
     * @return GetOrderHistoryQuery
     */
    public function withEarliestHistoryDate($EarliestHistoryDate)
    {
        $new = clone $this;
        $new->EarliestHistoryDate = $EarliestHistoryDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }

    /**
     * @param string $LanguageCode
     * @return GetOrderHistoryQuery
     */
    public function withLanguageCode($LanguageCode)
    {
        $new = clone $this;
        $new->LanguageCode = $LanguageCode;

        return $new;
    }

    /**
     * @return int
     */
    public function getNumberOfPeriods()
    {
        return $this->NumberOfPeriods;
    }

    /**
     * @param int $NumberOfPeriods
     * @return GetOrderHistoryQuery
     */
    public function withNumberOfPeriods($NumberOfPeriods)
    {
        $new = clone $this;
        $new->NumberOfPeriods = $NumberOfPeriods;

        return $new;
    }

    /**
     * @return string
     */
    public function getOldCustomerNumber()
    {
        return $this->OldCustomerNumber;
    }

    /**
     * @param string $OldCustomerNumber
     * @return GetOrderHistoryQuery
     */
    public function withOldCustomerNumber($OldCustomerNumber)
    {
        $new = clone $this;
        $new->OldCustomerNumber = $OldCustomerNumber;

        return $new;
    }
}
