<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetPriceItem implements JsonSerializable, RequestInterface
{
    /**
     * @var float
     */
    private $BasisVarDiscount;

    /**
     * @var float
     */
    private $GrossPrice;

    /**
     * @var float
     */
    private $NettPriceExclVAT;

    /**
     * @var float
     */
    private $NettPriceInclVAT;

    /**
     * @var string
     */
    private $UOM;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'BasisVarDiscount' => $this->BasisVarDiscount,
            'GrossPrice'       => $this->GrossPrice,
            'NettPriceExclVAT' => $this->NettPriceExclVAT,
            'NettPriceInclVAT' => $this->NettPriceInclVAT,
            'UOM'              => $this->UOM,
        ];
    }

    /**
     * Constructor
     *
     * @var float $BasisVarDiscount
     * @var float $GrossPrice
     * @var float $NettPriceExclVAT
     * @var float $NettPriceInclVAT
     * @var string $UOM
     */
    public function __construct($BasisVarDiscount, $GrossPrice, $NettPriceExclVAT, $NettPriceInclVAT, $UOM)
    {
        $this->BasisVarDiscount = $BasisVarDiscount;
        $this->GrossPrice = $GrossPrice;
        $this->NettPriceExclVAT = $NettPriceExclVAT;
        $this->NettPriceInclVAT = $NettPriceInclVAT;
        $this->UOM = $UOM;
    }

    /**
     * @return float
     */
    public function getBasisVarDiscount()
    {
        return $this->BasisVarDiscount;
    }

    /**
     * @param float $BasisVarDiscount
     * @return GetPriceItem
     */
    public function withBasisVarDiscount($BasisVarDiscount)
    {
        $new = clone $this;
        $new->BasisVarDiscount = $BasisVarDiscount;

        return $new;
    }

    /**
     * @return float
     */
    public function getGrossPrice()
    {
        return $this->GrossPrice;
    }

    /**
     * @param float $GrossPrice
     * @return GetPriceItem
     */
    public function withGrossPrice($GrossPrice)
    {
        $new = clone $this;
        $new->GrossPrice = $GrossPrice;

        return $new;
    }

    /**
     * @return float
     */
    public function getNettPriceExclVAT()
    {
        return $this->NettPriceExclVAT;
    }

    /**
     * @param float $NettPriceExclVAT
     * @return GetPriceItem
     */
    public function withNettPriceExclVAT($NettPriceExclVAT)
    {
        $new = clone $this;
        $new->NettPriceExclVAT = $NettPriceExclVAT;

        return $new;
    }

    /**
     * @return float
     */
    public function getNettPriceInclVAT()
    {
        return $this->NettPriceInclVAT;
    }

    /**
     * @param float $NettPriceInclVAT
     * @return GetPriceItem
     */
    public function withNettPriceInclVAT($NettPriceInclVAT)
    {
        $new = clone $this;
        $new->NettPriceInclVAT = $NettPriceInclVAT;

        return $new;
    }

    /**
     * @return string
     */
    public function getUOM()
    {
        return $this->UOM;
    }

    /**
     * @param string $UOM
     * @return GetPriceItem
     */
    public function withUOM($UOM)
    {
        $new = clone $this;
        $new->UOM = $UOM;

        return $new;
    }
}
