<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class VerifyLoginResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $ABcode;

    /**
     * @var string
     */
    private $CUNumber;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfAccount
     */
    private $DeliveryCustomers;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var string
     */
    private $InvoiceCUNumber;

    /**
     * @var bool
     */
    private $IsDeliveryCustomer;

    /**
     * @var bool
     */
    private $IsInvoiceCustomer;

    /**
     * @var string
     */
    private $OldCustomerNumber;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ABcode'             => $this->ABcode,
            'CUNumber'           => $this->CUNumber,
            'DeliveryCustomers'  => $this->DeliveryCustomers,
            'Division'           => $this->Division,
            'ErrorMessage'       => $this->ErrorMessage,
            'InvoiceCUNumber'    => $this->InvoiceCUNumber,
            'IsDeliveryCustomer' => $this->IsDeliveryCustomer,
            'IsInvoiceCustomer'  => $this->IsInvoiceCustomer,
            'OldCustomerNumber'  => $this->OldCustomerNumber,
            'ReturnCode'         => $this->ReturnCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $ABcode
     * @var string $CUNumber
     * @var \MSML\BizTalk\Type\Base\ArrayOfAccount $DeliveryCustomers
     * @var string $Division
     * @var string $ErrorMessage
     * @var string $InvoiceCUNumber
     * @var bool $IsDeliveryCustomer
     * @var bool $IsInvoiceCustomer
     * @var string $OldCustomerNumber
     * @var string $ReturnCode
     */
    public function __construct($ABcode, $CUNumber, $DeliveryCustomers, $Division, $ErrorMessage, $InvoiceCUNumber, $IsDeliveryCustomer, $IsInvoiceCustomer, $OldCustomerNumber, $ReturnCode)
    {
        $this->ABcode = $ABcode;
        $this->CUNumber = $CUNumber;
        $this->DeliveryCustomers = $DeliveryCustomers;
        $this->Division = $Division;
        $this->ErrorMessage = $ErrorMessage;
        $this->InvoiceCUNumber = $InvoiceCUNumber;
        $this->IsDeliveryCustomer = $IsDeliveryCustomer;
        $this->IsInvoiceCustomer = $IsInvoiceCustomer;
        $this->OldCustomerNumber = $OldCustomerNumber;
        $this->ReturnCode = $ReturnCode;
    }

    /**
     * @return string
     */
    public function getABcode()
    {
        return $this->ABcode;
    }

    /**
     * @param string $ABcode
     * @return VerifyLoginResult
     */
    public function withABcode($ABcode)
    {
        $new = clone $this;
        $new->ABcode = $ABcode;

        return $new;
    }

    /**
     * @return string
     */
    public function getCUNumber()
    {
        return $this->CUNumber;
    }

    /**
     * @param string $CUNumber
     * @return VerifyLoginResult
     */
    public function withCUNumber($CUNumber)
    {
        $new = clone $this;
        $new->CUNumber = $CUNumber;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfAccount
     */
    public function getDeliveryCustomers()
    {
        return $this->DeliveryCustomers;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfAccount $DeliveryCustomers
     * @return VerifyLoginResult
     */
    public function withDeliveryCustomers($DeliveryCustomers)
    {
        $new = clone $this;
        $new->DeliveryCustomers = $DeliveryCustomers;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return VerifyLoginResult
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return VerifyLoginResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return string
     */
    public function getInvoiceCUNumber()
    {
        return $this->InvoiceCUNumber;
    }

    /**
     * @param string $InvoiceCUNumber
     * @return VerifyLoginResult
     */
    public function withInvoiceCUNumber($InvoiceCUNumber)
    {
        $new = clone $this;
        $new->InvoiceCUNumber = $InvoiceCUNumber;

        return $new;
    }

    /**
     * @return bool
     */
    public function getIsDeliveryCustomer()
    {
        return $this->IsDeliveryCustomer;
    }

    /**
     * @param bool $IsDeliveryCustomer
     * @return VerifyLoginResult
     */
    public function withIsDeliveryCustomer($IsDeliveryCustomer)
    {
        $new = clone $this;
        $new->IsDeliveryCustomer = $IsDeliveryCustomer;

        return $new;
    }

    /**
     * @return bool
     */
    public function getIsInvoiceCustomer()
    {
        return $this->IsInvoiceCustomer;
    }

    /**
     * @param bool $IsInvoiceCustomer
     * @return VerifyLoginResult
     */
    public function withIsInvoiceCustomer($IsInvoiceCustomer)
    {
        $new = clone $this;
        $new->IsInvoiceCustomer = $IsInvoiceCustomer;

        return $new;
    }

    /**
     * @return string
     */
    public function getOldCustomerNumber()
    {
        return $this->OldCustomerNumber;
    }

    /**
     * @param string $OldCustomerNumber
     * @return VerifyLoginResult
     */
    public function withOldCustomerNumber($OldCustomerNumber)
    {
        $new = clone $this;
        $new->OldCustomerNumber = $OldCustomerNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return VerifyLoginResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
