<?php

namespace MSML\BizTalk\Type\PrimaryContact;

use JsonSerializable;
use Phpro\SoapClient\Type\ResultInterface;

class RegisterPrimaryContactResponse implements JsonSerializable, ResultInterface
{
    /**
     * @var string
     */
    private $contactRef;

    /**
     * @var string
     */
    private $errorCode;

    /**
     * @var string
     */
    private $errorMessage;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'contactRef'   => $this->contactRef,
            'errorCode'    => $this->errorCode,
            'errorMessage' => $this->errorMessage,
        ];
    }

    /**
     * @return string
     */
    public function getContactRef()
    {
        return $this->contactRef;
    }

    /**
     * @param string $contactRef
     * @return RegisterPrimaryContactResponse
     */
    public function withContactRef($contactRef)
    {
        $new = clone $this;
        $new->contactRef = $contactRef;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     * @param string $errorCode
     * @return RegisterPrimaryContactResponse
     */
    public function withErrorCode($errorCode)
    {
        $new = clone $this;
        $new->errorCode = $errorCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }

    /**
     * @param string $errorMessage
     * @return RegisterPrimaryContactResponse
     */
    public function withErrorMessage($errorMessage)
    {
        $new = clone $this;
        $new->errorMessage = $errorMessage;

        return $new;
    }
}
