<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ArrayOfBaseDataResult implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\BaseDataResult
     */
    private $BaseDataResult;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'BaseDataResult' => $this->BaseDataResult,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\BaseDataResult $BaseDataResult
     */
    public function __construct($BaseDataResult)
    {
        $this->BaseDataResult = $BaseDataResult;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\BaseDataResult
     */
    public function getBaseDataResult()
    {
        return $this->BaseDataResult;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\BaseDataResult $BaseDataResult
     * @return ArrayOfBaseDataResult
     */
    public function withBaseDataResult($BaseDataResult)
    {
        $new = clone $this;
        $new->BaseDataResult = $BaseDataResult;

        return $new;
    }
}
