<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ArrayOfPeriod implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\Period
     */
    private $Period;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Period' => $this->Period,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\Period $Period
     */
    public function __construct($Period)
    {
        $this->Period = $Period;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Period
     */
    public function getPeriod()
    {
        return $this->Period;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Period $Period
     * @return ArrayOfPeriod
     */
    public function withPeriod($Period)
    {
        $new = clone $this;
        $new->Period = $Period;

        return $new;
    }
}
