<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class DRRException implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $ExMessage;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ExMessage' => $this->ExMessage,
        ];
    }

    /**
     * Constructor
     *
     * @var string $ExMessage
     */
    public function __construct($ExMessage)
    {
        $this->ExMessage = $ExMessage;
    }

    /**
     * @return string
     */
    public function getExMessage()
    {
        return $this->ExMessage;
    }

    /**
     * @param string $ExMessage
     * @return DRRException
     */
    public function withExMessage($ExMessage)
    {
        $new = clone $this;
        $new->ExMessage = $ExMessage;

        return $new;
    }
}
