<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class Document implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\base64Binary
     */
    private $Content;

    /**
     * @var \MSML\BizTalk\Type\Base\Information
     */
    private $Information;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Content'     => $this->Content,
            'Information' => $this->Information,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\base64Binary $Content
     * @var \MSML\BizTalk\Type\Base\Information $Information
     */
    public function __construct($Content, $Information)
    {
        $this->Content = $Content;
        $this->Information = $Information;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\base64Binary
     */
    public function getContent()
    {
        return $this->Content;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\base64Binary $Content
     * @return Document
     */
    public function withContent($Content)
    {
        $new = clone $this;
        $new->Content = $Content;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Information
     */
    public function getInformation()
    {
        return $this->Information;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Information $Information
     * @return Document
     */
    public function withInformation($Information)
    {
        $new = clone $this;
        $new->Information = $Information;

        return $new;
    }
}
