<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GasMeterInfoResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfGasMeterInfo
     */
    private $GasMeterInfos;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ErrorMessage'  => $this->ErrorMessage,
            'GasMeterInfos' => $this->GasMeterInfos,
            'ReturnCode'    => $this->ReturnCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $ErrorMessage
     * @var \MSML\BizTalk\Type\Base\ArrayOfGasMeterInfo $GasMeterInfos
     * @var string $ReturnCode
     */
    public function __construct($ErrorMessage, $GasMeterInfos, $ReturnCode)
    {
        $this->ErrorMessage = $ErrorMessage;
        $this->GasMeterInfos = $GasMeterInfos;
        $this->ReturnCode = $ReturnCode;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GasMeterInfoResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfGasMeterInfo
     */
    public function getGasMeterInfos()
    {
        return $this->GasMeterInfos;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfGasMeterInfo $GasMeterInfos
     * @return GasMeterInfoResult
     */
    public function withGasMeterInfos($GasMeterInfos)
    {
        $new = clone $this;
        $new->GasMeterInfos = $GasMeterInfos;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GasMeterInfoResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
