<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetCustomerLedgerEntryQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var \DateTime
     */
    private $EarliestHistoryDate;

    /**
     * @var string
     */
    private $OldCustomerNumber;

    /**
     * @var bool
     */
    private $ShowOnlyOpenEntries;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode'        => $this->CustomerCode,
            'Division'            => $this->Division,
            'EarliestHistoryDate' => $this->EarliestHistoryDate,
            'OldCustomerNumber'   => $this->OldCustomerNumber,
            'ShowOnlyOpenEntries' => $this->ShowOnlyOpenEntries,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var string $Division
     * @var \DateTime $EarliestHistoryDate
     * @var string $OldCustomerNumber
     * @var bool $ShowOnlyOpenEntries
     */
    public function __construct($CustomerCode, $Division, $EarliestHistoryDate, $OldCustomerNumber, $ShowOnlyOpenEntries)
    {
        $this->CustomerCode = $CustomerCode;
        $this->Division = $Division;
        $this->EarliestHistoryDate = $EarliestHistoryDate;
        $this->OldCustomerNumber = $OldCustomerNumber;
        $this->ShowOnlyOpenEntries = $ShowOnlyOpenEntries;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetCustomerLedgerEntryQuery
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return GetCustomerLedgerEntryQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return \DateTime
     */
    public function getEarliestHistoryDate()
    {
        return $this->EarliestHistoryDate;
    }

    /**
     * @param \DateTime $EarliestHistoryDate
     * @return GetCustomerLedgerEntryQuery
     */
    public function withEarliestHistoryDate($EarliestHistoryDate)
    {
        $new = clone $this;
        $new->EarliestHistoryDate = $EarliestHistoryDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getOldCustomerNumber()
    {
        return $this->OldCustomerNumber;
    }

    /**
     * @param string $OldCustomerNumber
     * @return GetCustomerLedgerEntryQuery
     */
    public function withOldCustomerNumber($OldCustomerNumber)
    {
        $new = clone $this;
        $new->OldCustomerNumber = $OldCustomerNumber;

        return $new;
    }

    /**
     * @return bool
     */
    public function getShowOnlyOpenEntries()
    {
        return $this->ShowOnlyOpenEntries;
    }

    /**
     * @param bool $ShowOnlyOpenEntries
     * @return GetCustomerLedgerEntryQuery
     */
    public function withShowOnlyOpenEntries($ShowOnlyOpenEntries)
    {
        $new = clone $this;
        $new->ShowOnlyOpenEntries = $ShowOnlyOpenEntries;

        return $new;
    }
}
