<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetSalesHistoryResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfSalesHistoryItem
     */
    private $Item;

    /**
     * @var string
     */
    private $LanguageCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode' => $this->CustomerCode,
            'ErrorMessage' => $this->ErrorMessage,
            'Item'         => $this->Item,
            'LanguageCode' => $this->LanguageCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var string $ErrorMessage
     * @var \MSML\BizTalk\Type\Base\ArrayOfSalesHistoryItem $Item
     * @var string $LanguageCode
     */
    public function __construct($CustomerCode, $ErrorMessage, $Item, $LanguageCode)
    {
        $this->CustomerCode = $CustomerCode;
        $this->ErrorMessage = $ErrorMessage;
        $this->Item = $Item;
        $this->LanguageCode = $LanguageCode;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetSalesHistoryResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetSalesHistoryResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfSalesHistoryItem
     */
    public function getItem()
    {
        return $this->Item;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfSalesHistoryItem $Item
     * @return GetSalesHistoryResult
     */
    public function withItem($Item)
    {
        $new = clone $this;
        $new->Item = $Item;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }

    /**
     * @param string $LanguageCode
     * @return GetSalesHistoryResult
     */
    public function withLanguageCode($LanguageCode)
    {
        $new = clone $this;
        $new->LanguageCode = $LanguageCode;

        return $new;
    }
}
