<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetServiceItemResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfServiceItem
     */
    private $Items;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode' => $this->CustomerCode,
            'ErrorMessage' => $this->ErrorMessage,
            'Items'        => $this->Items,
            'ReturnCode'   => $this->ReturnCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var string $ErrorMessage
     * @var \MSML\BizTalk\Type\Base\ArrayOfServiceItem $Items
     * @var string $ReturnCode
     */
    public function __construct($CustomerCode, $ErrorMessage, $Items, $ReturnCode)
    {
        $this->CustomerCode = $CustomerCode;
        $this->ErrorMessage = $ErrorMessage;
        $this->Items = $Items;
        $this->ReturnCode = $ReturnCode;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetServiceItemResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetServiceItemResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfServiceItem
     */
    public function getItems()
    {
        return $this->Items;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfServiceItem $Items
     * @return GetServiceItemResult
     */
    public function withItems($Items)
    {
        $new = clone $this;
        $new->Items = $Items;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetServiceItemResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
