<?php

namespace MSML\BizTalk\Type\Order;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class CreateOrder implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $createdByNo;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $invoiceNo;

    /**
     * @var string
     */
    private $deliveryNo;

    /**
     * @var string
     */
    private $userName;

    /**
     * @var float
     */
    private $tankPercentage;

    /**
     * @var string
     */
    private $remarks;

    /**
     * @var string
     */
    private $tankNo;

    /**
     * @var \MSML\BizTalk\Type\Order\commentForTripPlanning
     */
    private $commentForTripPlanning;

    /**
     * @var \MSML\BizTalk\Type\Order\yourReference
     */
    private $yourReference;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'createdByNo'            => $this->createdByNo,
            'Division'               => $this->Division,
            'invoiceNo'              => $this->invoiceNo,
            'deliveryNo'             => $this->deliveryNo,
            'userName'               => $this->userName,
            'tankPercentage'         => $this->tankPercentage,
            'remarks'                => $this->remarks,
            'tankNo'                 => $this->tankNo,
            'commentForTripPlanning' => $this->commentForTripPlanning,
            'yourReference'          => $this->yourReference,
        ];
    }

    /**
     * Constructor
     *
     * @var string $createdByNo
     * @var string $Division
     * @var string $invoiceNo
     * @var string $deliveryNo
     * @var string $userName
     * @var float $tankPercentage
     * @var string $remarks
     * @var string $tankNo
     * @var \MSML\BizTalk\Type\Order\commentForTripPlanning $commentForTripPlanning
     * @var \MSML\BizTalk\Type\Order\yourReference $yourReference
     */
    public function __construct($createdByNo, $Division, $invoiceNo, $deliveryNo, $userName, $tankPercentage, $remarks, $tankNo, $commentForTripPlanning, $yourReference)
    {
        $this->createdByNo = $createdByNo;
        $this->Division = $Division;
        $this->invoiceNo = $invoiceNo;
        $this->deliveryNo = $deliveryNo;
        $this->userName = $userName;
        $this->tankPercentage = $tankPercentage;
        $this->remarks = $remarks;
        $this->tankNo = $tankNo;
        $this->commentForTripPlanning = $commentForTripPlanning;
        $this->yourReference = $yourReference;
    }

    /**
     * @return string
     */
    public function getCreatedByNo()
    {
        return $this->createdByNo;
    }

    /**
     * @param string $createdByNo
     * @return CreateOrder
     */
    public function withCreatedByNo($createdByNo)
    {
        $new = clone $this;
        $new->createdByNo = $createdByNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return CreateOrder
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getInvoiceNo()
    {
        return $this->invoiceNo;
    }

    /**
     * @param string $invoiceNo
     * @return CreateOrder
     */
    public function withInvoiceNo($invoiceNo)
    {
        $new = clone $this;
        $new->invoiceNo = $invoiceNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getDeliveryNo()
    {
        return $this->deliveryNo;
    }

    /**
     * @param string $deliveryNo
     * @return CreateOrder
     */
    public function withDeliveryNo($deliveryNo)
    {
        $new = clone $this;
        $new->deliveryNo = $deliveryNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     * @return CreateOrder
     */
    public function withUserName($userName)
    {
        $new = clone $this;
        $new->userName = $userName;

        return $new;
    }

    /**
     * @return float
     */
    public function getTankPercentage()
    {
        return $this->tankPercentage;
    }

    /**
     * @param float $tankPercentage
     * @return CreateOrder
     */
    public function withTankPercentage($tankPercentage)
    {
        $new = clone $this;
        $new->tankPercentage = $tankPercentage;

        return $new;
    }

    /**
     * @return string
     */
    public function getRemarks()
    {
        return $this->remarks;
    }

    /**
     * @param string $remarks
     * @return CreateOrder
     */
    public function withRemarks($remarks)
    {
        $new = clone $this;
        $new->remarks = $remarks;

        return $new;
    }

    /**
     * @return string
     */
    public function getTankNo()
    {
        return $this->tankNo;
    }

    /**
     * @param string $tankNo
     * @return CreateOrder
     */
    public function withTankNo($tankNo)
    {
        $new = clone $this;
        $new->tankNo = $tankNo;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Order\commentForTripPlanning
     */
    public function getCommentForTripPlanning()
    {
        return $this->commentForTripPlanning;
    }

    /**
     * @param \MSML\BizTalk\Type\Order\commentForTripPlanning $commentForTripPlanning
     * @return CreateOrder
     */
    public function withCommentForTripPlanning($commentForTripPlanning)
    {
        $new = clone $this;
        $new->commentForTripPlanning = $commentForTripPlanning;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Order\yourReference
     */
    public function getYourReference()
    {
        return $this->yourReference;
    }

    /**
     * @param \MSML\BizTalk\Type\Order\yourReference $yourReference
     * @return CreateOrder
     */
    public function withYourReference($yourReference)
    {
        $new = clone $this;
        $new->yourReference = $yourReference;

        return $new;
    }
}
