<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ActivateUser implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\ActivateUserQuery
     */
    private $request;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'request' => $this->request,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\ActivateUserQuery $request
     */
    public function __construct($request)
    {
        $this->request = $request;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ActivateUserQuery
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ActivateUserQuery $request
     * @return ActivateUser
     */
    public function withRequest($request)
    {
        $new = clone $this;
        $new->request = $request;

        return $new;
    }
}
