<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ArrayOfSalesHistoryItemPeriod implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\SalesHistoryItemPeriod
     */
    private $SalesHistoryItemPeriod;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'SalesHistoryItemPeriod' => $this->SalesHistoryItemPeriod,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\SalesHistoryItemPeriod $SalesHistoryItemPeriod
     */
    public function __construct($SalesHistoryItemPeriod)
    {
        $this->SalesHistoryItemPeriod = $SalesHistoryItemPeriod;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\SalesHistoryItemPeriod
     */
    public function getSalesHistoryItemPeriod()
    {
        return $this->SalesHistoryItemPeriod;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\SalesHistoryItemPeriod $SalesHistoryItemPeriod
     * @return ArrayOfSalesHistoryItemPeriod
     */
    public function withSalesHistoryItemPeriod($SalesHistoryItemPeriod)
    {
        $new = clone $this;
        $new->SalesHistoryItemPeriod = $SalesHistoryItemPeriod;

        return $new;
    }
}
