<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetDocumentResult implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\Document
     */
    private $Document;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Document'     => $this->Document,
            'ErrorMessage' => $this->ErrorMessage,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\Document $Document
     * @var string $ErrorMessage
     */
    public function __construct($Document, $ErrorMessage)
    {
        $this->Document = $Document;
        $this->ErrorMessage = $ErrorMessage;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Document
     */
    public function getDocument()
    {
        return $this->Document;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Document $Document
     * @return GetDocumentResult
     */
    public function withDocument($Document)
    {
        $new = clone $this;
        $new->Document = $Document;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetDocumentResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }
}
