<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetPricesAndDiscountsResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $CustomerDiscGroup;

    /**
     * @var string
     */
    private $CustomerDiscGroupDescription;

    /**
     * @var string
     */
    private $CustomerPriceGroup;

    /**
     * @var string
     */
    private $CustomerPriceGroupDescription;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfGetPriceAndDiscountItem
     */
    private $Items;

    /**
     * @var string
     */
    private $LanguageCode;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode'                  => $this->CustomerCode,
            'CustomerDiscGroup'             => $this->CustomerDiscGroup,
            'CustomerDiscGroupDescription'  => $this->CustomerDiscGroupDescription,
            'CustomerPriceGroup'            => $this->CustomerPriceGroup,
            'CustomerPriceGroupDescription' => $this->CustomerPriceGroupDescription,
            'ErrorMessage'                  => $this->ErrorMessage,
            'Items'                         => $this->Items,
            'LanguageCode'                  => $this->LanguageCode,
            'ReturnCode'                    => $this->ReturnCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var string $CustomerDiscGroup
     * @var string $CustomerDiscGroupDescription
     * @var string $CustomerPriceGroup
     * @var string $CustomerPriceGroupDescription
     * @var string $ErrorMessage
     * @var \MSML\BizTalk\Type\Base\ArrayOfGetPriceAndDiscountItem $Items
     * @var string $LanguageCode
     * @var string $ReturnCode
     */
    public function __construct($CustomerCode, $CustomerDiscGroup, $CustomerDiscGroupDescription, $CustomerPriceGroup, $CustomerPriceGroupDescription, $ErrorMessage, $Items, $LanguageCode, $ReturnCode)
    {
        $this->CustomerCode = $CustomerCode;
        $this->CustomerDiscGroup = $CustomerDiscGroup;
        $this->CustomerDiscGroupDescription = $CustomerDiscGroupDescription;
        $this->CustomerPriceGroup = $CustomerPriceGroup;
        $this->CustomerPriceGroupDescription = $CustomerPriceGroupDescription;
        $this->ErrorMessage = $ErrorMessage;
        $this->Items = $Items;
        $this->LanguageCode = $LanguageCode;
        $this->ReturnCode = $ReturnCode;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetPricesAndDiscountsResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getCustomerDiscGroup()
    {
        return $this->CustomerDiscGroup;
    }

    /**
     * @param string $CustomerDiscGroup
     * @return GetPricesAndDiscountsResult
     */
    public function withCustomerDiscGroup($CustomerDiscGroup)
    {
        $new = clone $this;
        $new->CustomerDiscGroup = $CustomerDiscGroup;

        return $new;
    }

    /**
     * @return string
     */
    public function getCustomerDiscGroupDescription()
    {
        return $this->CustomerDiscGroupDescription;
    }

    /**
     * @param string $CustomerDiscGroupDescription
     * @return GetPricesAndDiscountsResult
     */
    public function withCustomerDiscGroupDescription($CustomerDiscGroupDescription)
    {
        $new = clone $this;
        $new->CustomerDiscGroupDescription = $CustomerDiscGroupDescription;

        return $new;
    }

    /**
     * @return string
     */
    public function getCustomerPriceGroup()
    {
        return $this->CustomerPriceGroup;
    }

    /**
     * @param string $CustomerPriceGroup
     * @return GetPricesAndDiscountsResult
     */
    public function withCustomerPriceGroup($CustomerPriceGroup)
    {
        $new = clone $this;
        $new->CustomerPriceGroup = $CustomerPriceGroup;

        return $new;
    }

    /**
     * @return string
     */
    public function getCustomerPriceGroupDescription()
    {
        return $this->CustomerPriceGroupDescription;
    }

    /**
     * @param string $CustomerPriceGroupDescription
     * @return GetPricesAndDiscountsResult
     */
    public function withCustomerPriceGroupDescription($CustomerPriceGroupDescription)
    {
        $new = clone $this;
        $new->CustomerPriceGroupDescription = $CustomerPriceGroupDescription;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetPricesAndDiscountsResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfGetPriceAndDiscountItem
     */
    public function getItems()
    {
        return $this->Items;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfGetPriceAndDiscountItem $Items
     * @return GetPricesAndDiscountsResult
     */
    public function withItems($Items)
    {
        $new = clone $this;
        $new->Items = $Items;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }

    /**
     * @param string $LanguageCode
     * @return GetPricesAndDiscountsResult
     */
    public function withLanguageCode($LanguageCode)
    {
        $new = clone $this;
        $new->LanguageCode = $LanguageCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetPricesAndDiscountsResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
