<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetServiceContractResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfServiceContractHeader
     */
    private $Headers;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode' => $this->CustomerCode,
            'ErrorMessage' => $this->ErrorMessage,
            'Headers'      => $this->Headers,
            'ReturnCode'   => $this->ReturnCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var string $ErrorMessage
     * @var \MSML\BizTalk\Type\Base\ArrayOfServiceContractHeader $Headers
     * @var string $ReturnCode
     */
    public function __construct($CustomerCode, $ErrorMessage, $Headers, $ReturnCode)
    {
        $this->CustomerCode = $CustomerCode;
        $this->ErrorMessage = $ErrorMessage;
        $this->Headers = $Headers;
        $this->ReturnCode = $ReturnCode;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetServiceContractResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetServiceContractResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfServiceContractHeader
     */
    public function getHeaders()
    {
        return $this->Headers;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfServiceContractHeader $Headers
     * @return GetServiceContractResult
     */
    public function withHeaders($Headers)
    {
        $new = clone $this;
        $new->Headers = $Headers;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetServiceContractResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
