<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetServiceItem implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\GetServiceItemQuery
     */
    private $request;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'request' => $this->request,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\GetServiceItemQuery $request
     */
    public function __construct($request)
    {
        $this->request = $request;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\GetServiceItemQuery
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\GetServiceItemQuery $request
     * @return GetServiceItem
     */
    public function withRequest($request)
    {
        $new = clone $this;
        $new->request = $request;

        return $new;
    }
}
