<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class Information implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $DisplayName;

    /**
     * @var string
     */
    private $Id;

    /**
     * @var string
     */
    private $InternalName;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'DisplayName'  => $this->DisplayName,
            'Id'           => $this->Id,
            'InternalName' => $this->InternalName,
        ];
    }

    /**
     * Constructor
     *
     * @var string $DisplayName
     * @var string $Id
     * @var string $InternalName
     */
    public function __construct($DisplayName, $Id, $InternalName)
    {
        $this->DisplayName = $DisplayName;
        $this->Id = $Id;
        $this->InternalName = $InternalName;
    }

    /**
     * @return string
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }

    /**
     * @param string $DisplayName
     * @return Information
     */
    public function withDisplayName($DisplayName)
    {
        $new = clone $this;
        $new->DisplayName = $DisplayName;

        return $new;
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * @param string $Id
     * @return Information
     */
    public function withId($Id)
    {
        $new = clone $this;
        $new->Id = $Id;

        return $new;
    }

    /**
     * @return string
     */
    public function getInternalName()
    {
        return $this->InternalName;
    }

    /**
     * @param string $InternalName
     * @return Information
     */
    public function withInternalName($InternalName)
    {
        $new = clone $this;
        $new->InternalName = $InternalName;

        return $new;
    }
}
