<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ResetPasswordResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CUNumber;

    /**
     * @var string
     */
    private $EmailAddress;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CUNumber'     => $this->CUNumber,
            'EmailAddress' => $this->EmailAddress,
            'ErrorMessage' => $this->ErrorMessage,
            'ReturnCode'   => $this->ReturnCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CUNumber
     * @var string $EmailAddress
     * @var string $ErrorMessage
     * @var string $ReturnCode
     */
    public function __construct($CUNumber, $EmailAddress, $ErrorMessage, $ReturnCode)
    {
        $this->CUNumber = $CUNumber;
        $this->EmailAddress = $EmailAddress;
        $this->ErrorMessage = $ErrorMessage;
        $this->ReturnCode = $ReturnCode;
    }

    /**
     * @return string
     */
    public function getCUNumber()
    {
        return $this->CUNumber;
    }

    /**
     * @param string $CUNumber
     * @return ResetPasswordResult
     */
    public function withCUNumber($CUNumber)
    {
        $new = clone $this;
        $new->CUNumber = $CUNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }

    /**
     * @param string $EmailAddress
     * @return ResetPasswordResult
     */
    public function withEmailAddress($EmailAddress)
    {
        $new = clone $this;
        $new->EmailAddress = $EmailAddress;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return ResetPasswordResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return ResetPasswordResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
