<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class SharePointSiteNotAvailableFault implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $Message;

    /**
     * @var string
     */
    private $Reason;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Message' => $this->Message,
            'Reason'  => $this->Reason,
        ];
    }

    /**
     * Constructor
     *
     * @var string $Message
     * @var string $Reason
     */
    public function __construct($Message, $Reason)
    {
        $this->Message = $Message;
        $this->Reason = $Reason;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->Message;
    }

    /**
     * @param string $Message
     * @return SharePointSiteNotAvailableFault
     */
    public function withMessage($Message)
    {
        $new = clone $this;
        $new->Message = $Message;

        return $new;
    }

    /**
     * @return string
     */
    public function getReason()
    {
        return $this->Reason;
    }

    /**
     * @param string $Reason
     * @return SharePointSiteNotAvailableFault
     */
    public function withReason($Reason)
    {
        $new = clone $this;
        $new->Reason = $Reason;

        return $new;
    }
}
