<?php

namespace MSML\BizTalk\Type\GasMeterScore;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class CreateGasMeterScore implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerNumber;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $GasMeterNumber;

    /**
     * @var \DateTime
     */
    private $RecordingDate;

    /**
     * @var float
     */
    private $Score;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerNumber' => $this->CustomerNumber,
            'Division'       => $this->Division,
            'GasMeterNumber' => $this->GasMeterNumber,
            'RecordingDate'  => $this->RecordingDate,
            'Score'          => $this->Score,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerNumber
     * @var string $Division
     * @var string $GasMeterNumber
     * @var \DateTime $RecordingDate
     * @var float $Score
     */
    public function __construct($CustomerNumber, $Division, $GasMeterNumber, $RecordingDate, $Score)
    {
        $this->CustomerNumber = $CustomerNumber;
        $this->Division = $Division;
        $this->GasMeterNumber = $GasMeterNumber;
        $this->RecordingDate = $RecordingDate;
        $this->Score = $Score;
    }

    /**
     * @return string
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }

    /**
     * @param string $CustomerNumber
     * @return CreateGasMeterScore
     */
    public function withCustomerNumber($CustomerNumber)
    {
        $new = clone $this;
        $new->CustomerNumber = $CustomerNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return CreateGasMeterScore
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getGasMeterNumber()
    {
        return $this->GasMeterNumber;
    }

    /**
     * @param string $GasMeterNumber
     * @return CreateGasMeterScore
     */
    public function withGasMeterNumber($GasMeterNumber)
    {
        $new = clone $this;
        $new->GasMeterNumber = $GasMeterNumber;

        return $new;
    }

    /**
     * @return \DateTime
     */
    public function getRecordingDate()
    {
        return $this->RecordingDate;
    }

    /**
     * @param \DateTime $RecordingDate
     * @return CreateGasMeterScore
     */
    public function withRecordingDate($RecordingDate)
    {
        $new = clone $this;
        $new->RecordingDate = $RecordingDate;

        return $new;
    }

    /**
     * @return float
     */
    public function getScore()
    {
        return $this->Score;
    }

    /**
     * @param float $Score
     * @return CreateGasMeterScore
     */
    public function withScore($Score)
    {
        $new = clone $this;
        $new->Score = $Score;

        return $new;
    }
}
