<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class Account implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $ABcode;

    /**
     * @var string
     */
    private $CUNumber;

    /**
     * @var string
     */
    private $DeliveryCustomerNumber;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ABcode'                 => $this->ABcode,
            'CUNumber'               => $this->CUNumber,
            'DeliveryCustomerNumber' => $this->DeliveryCustomerNumber,
        ];
    }

    /**
     * Constructor
     *
     * @var string $ABcode
     * @var string $CUNumber
     * @var string $DeliveryCustomerNumber
     */
    public function __construct($ABcode, $CUNumber, $DeliveryCustomerNumber)
    {
        $this->ABcode = $ABcode;
        $this->CUNumber = $CUNumber;
        $this->DeliveryCustomerNumber = $DeliveryCustomerNumber;
    }

    /**
     * @return string
     */
    public function getABcode()
    {
        return $this->ABcode;
    }

    /**
     * @param string $ABcode
     * @return Account
     */
    public function withABcode($ABcode)
    {
        $new = clone $this;
        $new->ABcode = $ABcode;

        return $new;
    }

    /**
     * @return string
     */
    public function getCUNumber()
    {
        return $this->CUNumber;
    }

    /**
     * @param string $CUNumber
     * @return Account
     */
    public function withCUNumber($CUNumber)
    {
        $new = clone $this;
        $new->CUNumber = $CUNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getDeliveryCustomerNumber()
    {
        return $this->DeliveryCustomerNumber;
    }

    /**
     * @param string $DeliveryCustomerNumber
     * @return Account
     */
    public function withDeliveryCustomerNumber($DeliveryCustomerNumber)
    {
        $new = clone $this;
        $new->DeliveryCustomerNumber = $DeliveryCustomerNumber;

        return $new;
    }
}
