<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ArrayOfSalesHistoryItem implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\SalesHistoryItem
     */
    private $SalesHistoryItem;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'SalesHistoryItem' => $this->SalesHistoryItem,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\SalesHistoryItem $SalesHistoryItem
     */
    public function __construct($SalesHistoryItem)
    {
        $this->SalesHistoryItem = $SalesHistoryItem;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\SalesHistoryItem
     */
    public function getSalesHistoryItem()
    {
        return $this->SalesHistoryItem;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\SalesHistoryItem $SalesHistoryItem
     * @return ArrayOfSalesHistoryItem
     */
    public function withSalesHistoryItem($SalesHistoryItem)
    {
        $new = clone $this;
        $new->SalesHistoryItem = $SalesHistoryItem;

        return $new;
    }
}
