<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ContactQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $ContactId;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ContactId' => $this->ContactId,
        ];
    }

    /**
     * Constructor
     *
     * @var string $ContactId
     */
    public function __construct($ContactId)
    {
        $this->ContactId = $ContactId;
    }

    /**
     * @return string
     */
    public function getContactId()
    {
        return $this->ContactId;
    }

    /**
     * @param string $ContactId
     * @return ContactQuery
     */
    public function withContactId($ContactId)
    {
        $new = clone $this;
        $new->ContactId = $ContactId;

        return $new;
    }
}
