<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class CustomerDataResult implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\CustomerData
     */
    private $CustomerData;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerData' => $this->CustomerData,
            'ErrorMessage' => $this->ErrorMessage,
            'ReturnCode'   => $this->ReturnCode,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\CustomerData $CustomerData
     * @var string $ErrorMessage
     * @var string $ReturnCode
     */
    public function __construct($CustomerData, $ErrorMessage, $ReturnCode)
    {
        $this->CustomerData = $CustomerData;
        $this->ErrorMessage = $ErrorMessage;
        $this->ReturnCode = $ReturnCode;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\CustomerData
     */
    public function getCustomerData()
    {
        return $this->CustomerData;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\CustomerData $CustomerData
     * @return CustomerDataResult
     */
    public function withCustomerData($CustomerData)
    {
        $new = clone $this;
        $new->CustomerData = $CustomerData;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return CustomerDataResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return CustomerDataResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
