<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class InvoiceLine implements JsonSerializable, RequestInterface
{
    /**
     * @var float
     */
    private $AmountExclVAT;

    /**
     * @var string
     */
    private $BaseUnitOfMeasure;

    /**
     * @var string
     */
    private $Description;

    /**
     * @var string
     */
    private $ItemNumber;

    /**
     * @var string
     */
    private $NumberOfProducts;

    /**
     * @var string
     */
    private $OrderLineNumber;

    /**
     * @var string
     */
    private $OrderNumber;

    /**
     * @var string
     */
    private $PriceUnitOfMeasure;

    /**
     * @var float
     */
    private $UnitPriceExclVAT;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'AmountExclVAT'      => $this->AmountExclVAT,
            'BaseUnitOfMeasure'  => $this->BaseUnitOfMeasure,
            'Description'        => $this->Description,
            'ItemNumber'         => $this->ItemNumber,
            'NumberOfProducts'   => $this->NumberOfProducts,
            'OrderLineNumber'    => $this->OrderLineNumber,
            'OrderNumber'        => $this->OrderNumber,
            'PriceUnitOfMeasure' => $this->PriceUnitOfMeasure,
            'UnitPriceExclVAT'   => $this->UnitPriceExclVAT,
        ];
    }

    /**
     * Constructor
     *
     * @var float $AmountExclVAT
     * @var string $BaseUnitOfMeasure
     * @var string $Description
     * @var string $ItemNumber
     * @var string $NumberOfProducts
     * @var string $OrderLineNumber
     * @var string $OrderNumber
     * @var string $PriceUnitOfMeasure
     * @var float $UnitPriceExclVAT
     */
    public function __construct($AmountExclVAT, $BaseUnitOfMeasure, $Description, $ItemNumber, $NumberOfProducts, $OrderLineNumber, $OrderNumber, $PriceUnitOfMeasure, $UnitPriceExclVAT)
    {
        $this->AmountExclVAT = $AmountExclVAT;
        $this->BaseUnitOfMeasure = $BaseUnitOfMeasure;
        $this->Description = $Description;
        $this->ItemNumber = $ItemNumber;
        $this->NumberOfProducts = $NumberOfProducts;
        $this->OrderLineNumber = $OrderLineNumber;
        $this->OrderNumber = $OrderNumber;
        $this->PriceUnitOfMeasure = $PriceUnitOfMeasure;
        $this->UnitPriceExclVAT = $UnitPriceExclVAT;
    }

    /**
     * @return float
     */
    public function getAmountExclVAT()
    {
        return $this->AmountExclVAT;
    }

    /**
     * @param float $AmountExclVAT
     * @return InvoiceLine
     */
    public function withAmountExclVAT($AmountExclVAT)
    {
        $new = clone $this;
        $new->AmountExclVAT = $AmountExclVAT;

        return $new;
    }

    /**
     * @return string
     */
    public function getBaseUnitOfMeasure()
    {
        return $this->BaseUnitOfMeasure;
    }

    /**
     * @param string $BaseUnitOfMeasure
     * @return InvoiceLine
     */
    public function withBaseUnitOfMeasure($BaseUnitOfMeasure)
    {
        $new = clone $this;
        $new->BaseUnitOfMeasure = $BaseUnitOfMeasure;

        return $new;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * @param string $Description
     * @return InvoiceLine
     */
    public function withDescription($Description)
    {
        $new = clone $this;
        $new->Description = $Description;

        return $new;
    }

    /**
     * @return string
     */
    public function getItemNumber()
    {
        return $this->ItemNumber;
    }

    /**
     * @param string $ItemNumber
     * @return InvoiceLine
     */
    public function withItemNumber($ItemNumber)
    {
        $new = clone $this;
        $new->ItemNumber = $ItemNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getNumberOfProducts()
    {
        return $this->NumberOfProducts;
    }

    /**
     * @param string $NumberOfProducts
     * @return InvoiceLine
     */
    public function withNumberOfProducts($NumberOfProducts)
    {
        $new = clone $this;
        $new->NumberOfProducts = $NumberOfProducts;

        return $new;
    }

    /**
     * @return string
     */
    public function getOrderLineNumber()
    {
        return $this->OrderLineNumber;
    }

    /**
     * @param string $OrderLineNumber
     * @return InvoiceLine
     */
    public function withOrderLineNumber($OrderLineNumber)
    {
        $new = clone $this;
        $new->OrderLineNumber = $OrderLineNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }

    /**
     * @param string $OrderNumber
     * @return InvoiceLine
     */
    public function withOrderNumber($OrderNumber)
    {
        $new = clone $this;
        $new->OrderNumber = $OrderNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getPriceUnitOfMeasure()
    {
        return $this->PriceUnitOfMeasure;
    }

    /**
     * @param string $PriceUnitOfMeasure
     * @return InvoiceLine
     */
    public function withPriceUnitOfMeasure($PriceUnitOfMeasure)
    {
        $new = clone $this;
        $new->PriceUnitOfMeasure = $PriceUnitOfMeasure;

        return $new;
    }

    /**
     * @return float
     */
    public function getUnitPriceExclVAT()
    {
        return $this->UnitPriceExclVAT;
    }

    /**
     * @param float $UnitPriceExclVAT
     * @return InvoiceLine
     */
    public function withUnitPriceExclVAT($UnitPriceExclVAT)
    {
        $new = clone $this;
        $new->UnitPriceExclVAT = $UnitPriceExclVAT;

        return $new;
    }
}
