<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class Period implements JsonSerializable, RequestInterface
{
    /**
     * @var float
     */
    private $April;

    /**
     * @var float
     */
    private $August;

    /**
     * @var float
     */
    private $December;

    /**
     * @var float
     */
    private $February;

    /**
     * @var float
     */
    private $January;

    /**
     * @var float
     */
    private $July;

    /**
     * @var float
     */
    private $June;

    /**
     * @var float
     */
    private $March;

    /**
     * @var float
     */
    private $May;

    /**
     * @var float
     */
    private $November;

    /**
     * @var float
     */
    private $October;

    /**
     * @var float
     */
    private $September;

    /**
     * @var int
     */
    private $Year;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'April'     => $this->April,
            'August'    => $this->August,
            'December'  => $this->December,
            'February'  => $this->February,
            'January'   => $this->January,
            'July'      => $this->July,
            'June'      => $this->June,
            'March'     => $this->March,
            'May'       => $this->May,
            'November'  => $this->November,
            'October'   => $this->October,
            'September' => $this->September,
            'Year'      => $this->Year,
        ];
    }

    /**
     * Constructor
     *
     * @var float $April
     * @var float $August
     * @var float $December
     * @var float $February
     * @var float $January
     * @var float $July
     * @var float $June
     * @var float $March
     * @var float $May
     * @var float $November
     * @var float $October
     * @var float $September
     * @var int $Year
     */
    public function __construct($April, $August, $December, $February, $January, $July, $June, $March, $May, $November, $October, $September, $Year)
    {
        $this->April = $April;
        $this->August = $August;
        $this->December = $December;
        $this->February = $February;
        $this->January = $January;
        $this->July = $July;
        $this->June = $June;
        $this->March = $March;
        $this->May = $May;
        $this->November = $November;
        $this->October = $October;
        $this->September = $September;
        $this->Year = $Year;
    }

    /**
     * @return float
     */
    public function getApril()
    {
        return $this->April;
    }

    /**
     * @param float $April
     * @return Period
     */
    public function withApril($April)
    {
        $new = clone $this;
        $new->April = $April;

        return $new;
    }

    /**
     * @return float
     */
    public function getAugust()
    {
        return $this->August;
    }

    /**
     * @param float $August
     * @return Period
     */
    public function withAugust($August)
    {
        $new = clone $this;
        $new->August = $August;

        return $new;
    }

    /**
     * @return float
     */
    public function getDecember()
    {
        return $this->December;
    }

    /**
     * @param float $December
     * @return Period
     */
    public function withDecember($December)
    {
        $new = clone $this;
        $new->December = $December;

        return $new;
    }

    /**
     * @return float
     */
    public function getFebruary()
    {
        return $this->February;
    }

    /**
     * @param float $February
     * @return Period
     */
    public function withFebruary($February)
    {
        $new = clone $this;
        $new->February = $February;

        return $new;
    }

    /**
     * @return float
     */
    public function getJanuary()
    {
        return $this->January;
    }

    /**
     * @param float $January
     * @return Period
     */
    public function withJanuary($January)
    {
        $new = clone $this;
        $new->January = $January;

        return $new;
    }

    /**
     * @return float
     */
    public function getJuly()
    {
        return $this->July;
    }

    /**
     * @param float $July
     * @return Period
     */
    public function withJuly($July)
    {
        $new = clone $this;
        $new->July = $July;

        return $new;
    }

    /**
     * @return float
     */
    public function getJune()
    {
        return $this->June;
    }

    /**
     * @param float $June
     * @return Period
     */
    public function withJune($June)
    {
        $new = clone $this;
        $new->June = $June;

        return $new;
    }

    /**
     * @return float
     */
    public function getMarch()
    {
        return $this->March;
    }

    /**
     * @param float $March
     * @return Period
     */
    public function withMarch($March)
    {
        $new = clone $this;
        $new->March = $March;

        return $new;
    }

    /**
     * @return float
     */
    public function getMay()
    {
        return $this->May;
    }

    /**
     * @param float $May
     * @return Period
     */
    public function withMay($May)
    {
        $new = clone $this;
        $new->May = $May;

        return $new;
    }

    /**
     * @return float
     */
    public function getNovember()
    {
        return $this->November;
    }

    /**
     * @param float $November
     * @return Period
     */
    public function withNovember($November)
    {
        $new = clone $this;
        $new->November = $November;

        return $new;
    }

    /**
     * @return float
     */
    public function getOctober()
    {
        return $this->October;
    }

    /**
     * @param float $October
     * @return Period
     */
    public function withOctober($October)
    {
        $new = clone $this;
        $new->October = $October;

        return $new;
    }

    /**
     * @return float
     */
    public function getSeptember()
    {
        return $this->September;
    }

    /**
     * @param float $September
     * @return Period
     */
    public function withSeptember($September)
    {
        $new = clone $this;
        $new->September = $September;

        return $new;
    }

    /**
     * @return int
     */
    public function getYear()
    {
        return $this->Year;
    }

    /**
     * @param int $Year
     * @return Period
     */
    public function withYear($Year)
    {
        $new = clone $this;
        $new->Year = $Year;

        return $new;
    }
}
