<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class RegisterUserQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $EmailAddress;

    /**
     * @var string
     */
    private $HouseNumber;

    /**
     * @var bool
     */
    private $OptOutOfEmail;

    /**
     * @var string
     */
    private $Password;

    /**
     * @var string
     */
    private $PostalCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode'  => $this->CustomerCode,
            'EmailAddress'  => $this->EmailAddress,
            'HouseNumber'   => $this->HouseNumber,
            'OptOutOfEmail' => $this->OptOutOfEmail,
            'Password'      => $this->Password,
            'PostalCode'    => $this->PostalCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var string $EmailAddress
     * @var string $HouseNumber
     * @var bool $OptOutOfEmail
     * @var string $Password
     * @var string $PostalCode
     */
    public function __construct($CustomerCode, $EmailAddress, $HouseNumber, $OptOutOfEmail, $Password, $PostalCode)
    {
        $this->CustomerCode = $CustomerCode;
        $this->EmailAddress = $EmailAddress;
        $this->HouseNumber = $HouseNumber;
        $this->OptOutOfEmail = $OptOutOfEmail;
        $this->Password = $Password;
        $this->PostalCode = $PostalCode;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return RegisterUserQuery
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }

    /**
     * @param string $EmailAddress
     * @return RegisterUserQuery
     */
    public function withEmailAddress($EmailAddress)
    {
        $new = clone $this;
        $new->EmailAddress = $EmailAddress;

        return $new;
    }

    /**
     * @return string
     */
    public function getHouseNumber()
    {
        return $this->HouseNumber;
    }

    /**
     * @param string $HouseNumber
     * @return RegisterUserQuery
     */
    public function withHouseNumber($HouseNumber)
    {
        $new = clone $this;
        $new->HouseNumber = $HouseNumber;

        return $new;
    }

    /**
     * @return bool
     */
    public function getOptOutOfEmail()
    {
        return $this->OptOutOfEmail;
    }

    /**
     * @param bool $OptOutOfEmail
     * @return RegisterUserQuery
     */
    public function withOptOutOfEmail($OptOutOfEmail)
    {
        $new = clone $this;
        $new->OptOutOfEmail = $OptOutOfEmail;

        return $new;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }

    /**
     * @param string $Password
     * @return RegisterUserQuery
     */
    public function withPassword($Password)
    {
        $new = clone $this;
        $new->Password = $Password;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }

    /**
     * @param string $PostalCode
     * @return RegisterUserQuery
     */
    public function withPostalCode($PostalCode)
    {
        $new = clone $this;
        $new->PostalCode = $PostalCode;

        return $new;
    }
}
