<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class SalesHistoryItemPeriod implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $April;

    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $August;

    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $December;

    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $Februari;

    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $Januari;

    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $July;

    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $June;

    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $March;

    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $May;

    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $November;

    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $October;

    /**
     * @var \MSML\BizTalk\Type\Base\Sales
     */
    private $September;

    /**
     * @var int
     */
    private $Year;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'April'     => $this->April,
            'August'    => $this->August,
            'December'  => $this->December,
            'Februari'  => $this->Februari,
            'Januari'   => $this->Januari,
            'July'      => $this->July,
            'June'      => $this->June,
            'March'     => $this->March,
            'May'       => $this->May,
            'November'  => $this->November,
            'October'   => $this->October,
            'September' => $this->September,
            'Year'      => $this->Year,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\Sales $April
     * @var \MSML\BizTalk\Type\Base\Sales $August
     * @var \MSML\BizTalk\Type\Base\Sales $December
     * @var \MSML\BizTalk\Type\Base\Sales $Februari
     * @var \MSML\BizTalk\Type\Base\Sales $Januari
     * @var \MSML\BizTalk\Type\Base\Sales $July
     * @var \MSML\BizTalk\Type\Base\Sales $June
     * @var \MSML\BizTalk\Type\Base\Sales $March
     * @var \MSML\BizTalk\Type\Base\Sales $May
     * @var \MSML\BizTalk\Type\Base\Sales $November
     * @var \MSML\BizTalk\Type\Base\Sales $October
     * @var \MSML\BizTalk\Type\Base\Sales $September
     * @var int $Year
     */
    public function __construct($April, $August, $December, $Februari, $Januari, $July, $June, $March, $May, $November, $October, $September, $Year)
    {
        $this->April = $April;
        $this->August = $August;
        $this->December = $December;
        $this->Februari = $Februari;
        $this->Januari = $Januari;
        $this->July = $July;
        $this->June = $June;
        $this->March = $March;
        $this->May = $May;
        $this->November = $November;
        $this->October = $October;
        $this->September = $September;
        $this->Year = $Year;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getApril()
    {
        return $this->April;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $April
     * @return SalesHistoryItemPeriod
     */
    public function withApril($April)
    {
        $new = clone $this;
        $new->April = $April;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getAugust()
    {
        return $this->August;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $August
     * @return SalesHistoryItemPeriod
     */
    public function withAugust($August)
    {
        $new = clone $this;
        $new->August = $August;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getDecember()
    {
        return $this->December;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $December
     * @return SalesHistoryItemPeriod
     */
    public function withDecember($December)
    {
        $new = clone $this;
        $new->December = $December;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getFebruari()
    {
        return $this->Februari;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $Februari
     * @return SalesHistoryItemPeriod
     */
    public function withFebruari($Februari)
    {
        $new = clone $this;
        $new->Februari = $Februari;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getJanuari()
    {
        return $this->Januari;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $Januari
     * @return SalesHistoryItemPeriod
     */
    public function withJanuari($Januari)
    {
        $new = clone $this;
        $new->Januari = $Januari;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getJuly()
    {
        return $this->July;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $July
     * @return SalesHistoryItemPeriod
     */
    public function withJuly($July)
    {
        $new = clone $this;
        $new->July = $July;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getJune()
    {
        return $this->June;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $June
     * @return SalesHistoryItemPeriod
     */
    public function withJune($June)
    {
        $new = clone $this;
        $new->June = $June;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getMarch()
    {
        return $this->March;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $March
     * @return SalesHistoryItemPeriod
     */
    public function withMarch($March)
    {
        $new = clone $this;
        $new->March = $March;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getMay()
    {
        return $this->May;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $May
     * @return SalesHistoryItemPeriod
     */
    public function withMay($May)
    {
        $new = clone $this;
        $new->May = $May;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getNovember()
    {
        return $this->November;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $November
     * @return SalesHistoryItemPeriod
     */
    public function withNovember($November)
    {
        $new = clone $this;
        $new->November = $November;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getOctober()
    {
        return $this->October;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $October
     * @return SalesHistoryItemPeriod
     */
    public function withOctober($October)
    {
        $new = clone $this;
        $new->October = $October;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\Sales
     */
    public function getSeptember()
    {
        return $this->September;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\Sales $September
     * @return SalesHistoryItemPeriod
     */
    public function withSeptember($September)
    {
        $new = clone $this;
        $new->September = $September;

        return $new;
    }

    /**
     * @return int
     */
    public function getYear()
    {
        return $this->Year;
    }

    /**
     * @param int $Year
     * @return SalesHistoryItemPeriod
     */
    public function withYear($Year)
    {
        $new = clone $this;
        $new->Year = $Year;

        return $new;
    }
}
