<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ServiceContractHeader implements JsonSerializable, RequestInterface
{
    /**
     * @var float
     */
    private $AnnualAmount;

    /**
     * @var string
     */
    private $CancelReasonCode;

    /**
     * @var string
     */
    private $ContractNo;

    /**
     * @var string
     */
    private $Description;

    /**
     * @var \DateTime
     */
    private $EndingDate;

    /**
     * @var float
     */
    private $ExpectedYearConsumption;

    /**
     * @var int
     */
    private $InvoicePeriod;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfServiceItem
     */
    private $Items;

    /**
     * @var string
     */
    private $PrimagazContractNo;

    /**
     * @var \DateTime
     */
    private $StartingDate;

    /**
     * @var string
     */
    private $Status;

    /**
     * @var string
     */
    private $YourReference;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'AnnualAmount'            => $this->AnnualAmount,
            'CancelReasonCode'        => $this->CancelReasonCode,
            'ContractNo'              => $this->ContractNo,
            'Description'             => $this->Description,
            'EndingDate'              => $this->EndingDate,
            'ExpectedYearConsumption' => $this->ExpectedYearConsumption,
            'InvoicePeriod'           => $this->InvoicePeriod,
            'Items'                   => $this->Items,
            'PrimagazContractNo'      => $this->PrimagazContractNo,
            'StartingDate'            => $this->StartingDate,
            'Status'                  => $this->Status,
            'YourReference'           => $this->YourReference,
        ];
    }

    /**
     * Constructor
     *
     * @var float $AnnualAmount
     * @var string $CancelReasonCode
     * @var string $ContractNo
     * @var string $Description
     * @var \DateTime $EndingDate
     * @var float $ExpectedYearConsumption
     * @var int $InvoicePeriod
     * @var \MSML\BizTalk\Type\Base\ArrayOfServiceItem $Items
     * @var string $PrimagazContractNo
     * @var \DateTime $StartingDate
     * @var string $Status
     * @var string $YourReference
     */
    public function __construct($AnnualAmount, $CancelReasonCode, $ContractNo, $Description, $EndingDate, $ExpectedYearConsumption, $InvoicePeriod, $Items, $PrimagazContractNo, $StartingDate, $Status, $YourReference)
    {
        $this->AnnualAmount = $AnnualAmount;
        $this->CancelReasonCode = $CancelReasonCode;
        $this->ContractNo = $ContractNo;
        $this->Description = $Description;
        $this->EndingDate = $EndingDate;
        $this->ExpectedYearConsumption = $ExpectedYearConsumption;
        $this->InvoicePeriod = $InvoicePeriod;
        $this->Items = $Items;
        $this->PrimagazContractNo = $PrimagazContractNo;
        $this->StartingDate = $StartingDate;
        $this->Status = $Status;
        $this->YourReference = $YourReference;
    }

    /**
     * @return float
     */
    public function getAnnualAmount()
    {
        return $this->AnnualAmount;
    }

    /**
     * @param float $AnnualAmount
     * @return ServiceContractHeader
     */
    public function withAnnualAmount($AnnualAmount)
    {
        $new = clone $this;
        $new->AnnualAmount = $AnnualAmount;

        return $new;
    }

    /**
     * @return string
     */
    public function getCancelReasonCode()
    {
        return $this->CancelReasonCode;
    }

    /**
     * @param string $CancelReasonCode
     * @return ServiceContractHeader
     */
    public function withCancelReasonCode($CancelReasonCode)
    {
        $new = clone $this;
        $new->CancelReasonCode = $CancelReasonCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getContractNo()
    {
        return $this->ContractNo;
    }

    /**
     * @param string $ContractNo
     * @return ServiceContractHeader
     */
    public function withContractNo($ContractNo)
    {
        $new = clone $this;
        $new->ContractNo = $ContractNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * @param string $Description
     * @return ServiceContractHeader
     */
    public function withDescription($Description)
    {
        $new = clone $this;
        $new->Description = $Description;

        return $new;
    }

    /**
     * @return \DateTime
     */
    public function getEndingDate()
    {
        return $this->EndingDate;
    }

    /**
     * @param \DateTime $EndingDate
     * @return ServiceContractHeader
     */
    public function withEndingDate($EndingDate)
    {
        $new = clone $this;
        $new->EndingDate = $EndingDate;

        return $new;
    }

    /**
     * @return float
     */
    public function getExpectedYearConsumption()
    {
        return $this->ExpectedYearConsumption;
    }

    /**
     * @param float $ExpectedYearConsumption
     * @return ServiceContractHeader
     */
    public function withExpectedYearConsumption($ExpectedYearConsumption)
    {
        $new = clone $this;
        $new->ExpectedYearConsumption = $ExpectedYearConsumption;

        return $new;
    }

    /**
     * @return int
     */
    public function getInvoicePeriod()
    {
        return $this->InvoicePeriod;
    }

    /**
     * @param int $InvoicePeriod
     * @return ServiceContractHeader
     */
    public function withInvoicePeriod($InvoicePeriod)
    {
        $new = clone $this;
        $new->InvoicePeriod = $InvoicePeriod;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfServiceItem
     */
    public function getItems()
    {
        return $this->Items;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfServiceItem $Items
     * @return ServiceContractHeader
     */
    public function withItems($Items)
    {
        $new = clone $this;
        $new->Items = $Items;

        return $new;
    }

    /**
     * @return string
     */
    public function getPrimagazContractNo()
    {
        return $this->PrimagazContractNo;
    }

    /**
     * @param string $PrimagazContractNo
     * @return ServiceContractHeader
     */
    public function withPrimagazContractNo($PrimagazContractNo)
    {
        $new = clone $this;
        $new->PrimagazContractNo = $PrimagazContractNo;

        return $new;
    }

    /**
     * @return \DateTime
     */
    public function getStartingDate()
    {
        return $this->StartingDate;
    }

    /**
     * @param \DateTime $StartingDate
     * @return ServiceContractHeader
     */
    public function withStartingDate($StartingDate)
    {
        $new = clone $this;
        $new->StartingDate = $StartingDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @param string $Status
     * @return ServiceContractHeader
     */
    public function withStatus($Status)
    {
        $new = clone $this;
        $new->Status = $Status;

        return $new;
    }

    /**
     * @return string
     */
    public function getYourReference()
    {
        return $this->YourReference;
    }

    /**
     * @param string $YourReference
     * @return ServiceContractHeader
     */
    public function withYourReference($YourReference)
    {
        $new = clone $this;
        $new->YourReference = $YourReference;

        return $new;
    }
}
