<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class TelemetryHistoryResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfFuelTankHistory
     */
    private $History;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode' => $this->CustomerCode,
            'Division'     => $this->Division,
            'ErrorMessage' => $this->ErrorMessage,
            'History'      => $this->History,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var string $Division
     * @var string $ErrorMessage
     * @var \MSML\BizTalk\Type\Base\ArrayOfFuelTankHistory $History
     */
    public function __construct($CustomerCode, $Division, $ErrorMessage, $History)
    {
        $this->CustomerCode = $CustomerCode;
        $this->Division = $Division;
        $this->ErrorMessage = $ErrorMessage;
        $this->History = $History;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return TelemetryHistoryResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return TelemetryHistoryResult
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return TelemetryHistoryResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfFuelTankHistory
     */
    public function getHistory()
    {
        return $this->History;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfFuelTankHistory $History
     * @return TelemetryHistoryResult
     */
    public function withHistory($History)
    {
        $new = clone $this;
        $new->History = $History;

        return $new;
    }
}
