<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class VerifyLogin implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\VerifyLoginQuery
     */
    private $request;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'request' => $this->request,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\VerifyLoginQuery $request
     */
    public function __construct($request)
    {
        $this->request = $request;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\VerifyLoginQuery
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\VerifyLoginQuery $request
     * @return VerifyLogin
     */
    public function withRequest($request)
    {
        $new = clone $this;
        $new->request = $request;

        return $new;
    }
}
