<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class VerifyLoginQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $Password;

    /**
     * @var string
     */
    private $UserName;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Password' => $this->Password,
            'UserName' => $this->UserName,
        ];
    }

    /**
     * Constructor
     *
     * @var string $Password
     * @var string $UserName
     */
    public function __construct($Password, $UserName)
    {
        $this->Password = $Password;
        $this->UserName = $UserName;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }

    /**
     * @param string $Password
     * @return VerifyLoginQuery
     */
    public function withPassword($Password)
    {
        $new = clone $this;
        $new->Password = $Password;

        return $new;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->UserName;
    }

    /**
     * @param string $UserName
     * @return VerifyLoginQuery
     */
    public function withUserName($UserName)
    {
        $new = clone $this;
        $new->UserName = $UserName;

        return $new;
    }
}
