<?php

namespace MSML\BizTalk\Type\BottleOrder;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class CreateBottleOrder implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $createdByNo;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $invoiceNo;

    /**
     * @var string
     */
    private $deliveryNo;

    /**
     * @var string
     */
    private $userName;

    /**
     * @var string
     */
    private $remarks;

    /**
     * @var \MSML\BizTalk\Type\BottleOrder\yourReference
     */
    private $yourReference;

    /**
     * @var \MSML\BizTalk\Type\BottleOrder\orderLine
     */
    private $orderLine;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'createdByNo'   => $this->createdByNo,
            'Division'      => $this->Division,
            'invoiceNo'     => $this->invoiceNo,
            'deliveryNo'    => $this->deliveryNo,
            'userName'      => $this->userName,
            'remarks'       => $this->remarks,
            'yourReference' => $this->yourReference,
            'orderLine'     => $this->orderLine,
        ];
    }

    /**
     * Constructor
     *
     * @var string $createdByNo
     * @var string $Division
     * @var string $invoiceNo
     * @var string $deliveryNo
     * @var string $userName
     * @var string $remarks
     * @var \MSML\BizTalk\Type\BottleOrder\yourReference $yourReference
     * @var \MSML\BizTalk\Type\BottleOrder\orderLine $orderLine
     */
    public function __construct($createdByNo, $Division, $invoiceNo, $deliveryNo, $userName, $remarks, $yourReference, $orderLine)
    {
        $this->createdByNo = $createdByNo;
        $this->Division = $Division;
        $this->invoiceNo = $invoiceNo;
        $this->deliveryNo = $deliveryNo;
        $this->userName = $userName;
        $this->remarks = $remarks;
        $this->yourReference = $yourReference;
        $this->orderLine = $orderLine;
    }

    /**
     * @return string
     */
    public function getCreatedByNo()
    {
        return $this->createdByNo;
    }

    /**
     * @param string $createdByNo
     * @return CreateBottleOrder
     */
    public function withCreatedByNo($createdByNo)
    {
        $new = clone $this;
        $new->createdByNo = $createdByNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return CreateBottleOrder
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getInvoiceNo()
    {
        return $this->invoiceNo;
    }

    /**
     * @param string $invoiceNo
     * @return CreateBottleOrder
     */
    public function withInvoiceNo($invoiceNo)
    {
        $new = clone $this;
        $new->invoiceNo = $invoiceNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getDeliveryNo()
    {
        return $this->deliveryNo;
    }

    /**
     * @param string $deliveryNo
     * @return CreateBottleOrder
     */
    public function withDeliveryNo($deliveryNo)
    {
        $new = clone $this;
        $new->deliveryNo = $deliveryNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     * @return CreateBottleOrder
     */
    public function withUserName($userName)
    {
        $new = clone $this;
        $new->userName = $userName;

        return $new;
    }

    /**
     * @return string
     */
    public function getRemarks()
    {
        return $this->remarks;
    }

    /**
     * @param string $remarks
     * @return CreateBottleOrder
     */
    public function withRemarks($remarks)
    {
        $new = clone $this;
        $new->remarks = $remarks;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\BottleOrder\yourReference
     */
    public function getYourReference()
    {
        return $this->yourReference;
    }

    /**
     * @param \MSML\BizTalk\Type\BottleOrder\yourReference $yourReference
     * @return CreateBottleOrder
     */
    public function withYourReference($yourReference)
    {
        $new = clone $this;
        $new->yourReference = $yourReference;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\BottleOrder\orderLine
     */
    public function getOrderLine()
    {
        return $this->orderLine;
    }

    /**
     * @param \MSML\BizTalk\Type\BottleOrder\orderLine $orderLine
     * @return CreateBottleOrder
     */
    public function withOrderLine($orderLine)
    {
        $new = clone $this;
        $new->orderLine = $orderLine;

        return $new;
    }
}
