<?php

namespace MSML\BizTalk\Type\PrimaryContact;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class registerPrimarayContact implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $billingPostalCode;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $firstName;

    /**
     * @var string
     */
    private $language;

    /**
     * @var string
     */
    private $lastName;

    /**
     * @var string
     */
    private $navisionNumber;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'billingPostalCode' => $this->billingPostalCode,
            'email'             => $this->email,
            'firstName'         => $this->firstName,
            'language'          => $this->language,
            'lastName'          => $this->lastName,
            'navisionNumber'    => $this->navisionNumber,
        ];
    }

    /**
     * Constructor
     *
     * @var string $billingPostalCode
     * @var string $email
     * @var string $firstName
     * @var string $language
     * @var string $lastName
     * @var string $navisionNumber
     */
    public function __construct($billingPostalCode, $email, $firstName, $language, $lastName, $navisionNumber)
    {
        $this->billingPostalCode = $billingPostalCode;
        $this->email = $email;
        $this->firstName = $firstName;
        $this->language = $language;
        $this->lastName = $lastName;
        $this->navisionNumber = $navisionNumber;
    }

    /**
     * @return string
     */
    public function getBillingPostalCode()
    {
        return $this->billingPostalCode;
    }

    /**
     * @param string $billingPostalCode
     * @return registerPrimarayContact
     */
    public function withBillingPostalCode($billingPostalCode)
    {
        $new = clone $this;
        $new->billingPostalCode = $billingPostalCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return registerPrimarayContact
     */
    public function withEmail($email)
    {
        $new = clone $this;
        $new->email = $email;

        return $new;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     * @return registerPrimarayContact
     */
    public function withFirstName($firstName)
    {
        $new = clone $this;
        $new->firstName = $firstName;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @param string $language
     * @return registerPrimarayContact
     */
    public function withLanguage($language)
    {
        $new = clone $this;
        $new->language = $language;

        return $new;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     * @return registerPrimarayContact
     */
    public function withLastName($lastName)
    {
        $new = clone $this;
        $new->lastName = $lastName;

        return $new;
    }

    /**
     * @return string
     */
    public function getNavisionNumber()
    {
        return $this->navisionNumber;
    }

    /**
     * @param string $navisionNumber
     * @return registerPrimarayContact
     */
    public function withNavisionNumber($navisionNumber)
    {
        $new = clone $this;
        $new->navisionNumber = $navisionNumber;

        return $new;
    }
}
