<?php

namespace MSML\BizTalk\Type\ShippingContact;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class MessageBody implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\ShippingContact\<anyXML>
     */
    private $any;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'any' => $this->any,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\ShippingContact\<anyXML> $any
     */
    public function __construct($any)
    {
        $this->any = $any;
    }

    /**
     * @return \MSML\BizTalk\Type\ShippingContact\<anyXML>
     */
    public function getAny()
    {
        return $this->any;
    }

    /**
     * @param \MSML\BizTalk\Type\ShippingContact\<anyXML> $any
     * @return MessageBody
     */
    public function withAny($any)
    {
        $new = clone $this;
        $new->any = $any;

        return $new;
    }
}
