<?php

namespace MSML\BizTalk;

use Illuminate\Support\ServiceProvider;

class BizTalkServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application events.
     */
    public function boot()
    {
        $this->publishes([
            __DIR__ . '/../config/biztalk.php' => config_path('biztalk.php'),
        ], 'config');
    }

    /**
     * Register the service provider.
     */
    public function register()
    {
        $this->app->singleton(BizTalk::class, function () {
            return new BizTalkClient();
        });

        $this->app->alias(BizTalkClient::class, 'biztalk');
    }
}
