<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ActivateUserQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $EmailAddress;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'EmailAddress' => $this->EmailAddress,
        ];
    }

    /**
     * Constructor
     *
     * @var string $EmailAddress
     */
    public function __construct($EmailAddress)
    {
        $this->EmailAddress = $EmailAddress;
    }

    /**
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }

    /**
     * @param string $EmailAddress
     * @return ActivateUserQuery
     */
    public function withEmailAddress($EmailAddress)
    {
        $new = clone $this;
        $new->EmailAddress = $EmailAddress;

        return $new;
    }
}
