<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class CustomerDataQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $Division;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode' => $this->CustomerCode,
            'Division'     => $this->Division,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var string $Division
     */
    public function __construct($CustomerCode, $Division)
    {
        $this->CustomerCode = $CustomerCode;
        $this->Division = $Division;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return CustomerDataQuery
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return CustomerDataQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }
}
