<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class FuelTankHistory implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfPeriod
     */
    private $Periods;

    /**
     * @var int
     */
    private $ShipToAddressCode;

    /**
     * @var string
     */
    private $TankNo;

    /**
     * @var string
     */
    private $TankUOM;

    /**
     * @var string
     */
    private $TelemetryID;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Periods'           => $this->Periods,
            'ShipToAddressCode' => $this->ShipToAddressCode,
            'TankNo'            => $this->TankNo,
            'TankUOM'           => $this->TankUOM,
            'TelemetryID'       => $this->TelemetryID,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\ArrayOfPeriod $Periods
     * @var int $ShipToAddressCode
     * @var string $TankNo
     * @var string $TankUOM
     * @var string $TelemetryID
     */
    public function __construct($Periods, $ShipToAddressCode, $TankNo, $TankUOM, $TelemetryID)
    {
        $this->Periods = $Periods;
        $this->ShipToAddressCode = $ShipToAddressCode;
        $this->TankNo = $TankNo;
        $this->TankUOM = $TankUOM;
        $this->TelemetryID = $TelemetryID;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfPeriod
     */
    public function getPeriods()
    {
        return $this->Periods;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfPeriod $Periods
     * @return FuelTankHistory
     */
    public function withPeriods($Periods)
    {
        $new = clone $this;
        $new->Periods = $Periods;

        return $new;
    }

    /**
     * @return int
     */
    public function getShipToAddressCode()
    {
        return $this->ShipToAddressCode;
    }

    /**
     * @param int $ShipToAddressCode
     * @return FuelTankHistory
     */
    public function withShipToAddressCode($ShipToAddressCode)
    {
        $new = clone $this;
        $new->ShipToAddressCode = $ShipToAddressCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getTankNo()
    {
        return $this->TankNo;
    }

    /**
     * @param string $TankNo
     * @return FuelTankHistory
     */
    public function withTankNo($TankNo)
    {
        $new = clone $this;
        $new->TankNo = $TankNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getTankUOM()
    {
        return $this->TankUOM;
    }

    /**
     * @param string $TankUOM
     * @return FuelTankHistory
     */
    public function withTankUOM($TankUOM)
    {
        $new = clone $this;
        $new->TankUOM = $TankUOM;

        return $new;
    }

    /**
     * @return string
     */
    public function getTelemetryID()
    {
        return $this->TelemetryID;
    }

    /**
     * @param string $TelemetryID
     * @return FuelTankHistory
     */
    public function withTelemetryID($TelemetryID)
    {
        $new = clone $this;
        $new->TelemetryID = $TelemetryID;

        return $new;
    }
}
