<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GasMeterInfoQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerNumber;

    /**
     * @var string
     */
    private $Division;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerNumber' => $this->CustomerNumber,
            'Division'       => $this->Division,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerNumber
     * @var string $Division
     */
    public function __construct($CustomerNumber, $Division)
    {
        $this->CustomerNumber = $CustomerNumber;
        $this->Division = $Division;
    }

    /**
     * @return string
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }

    /**
     * @param string $CustomerNumber
     * @return GasMeterInfoQuery
     */
    public function withCustomerNumber($CustomerNumber)
    {
        $new = clone $this;
        $new->CustomerNumber = $CustomerNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return GasMeterInfoQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }
}
