<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetDocument implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\GetDocumentQuery
     */
    private $invoiceNumber;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'invoiceNumber' => $this->invoiceNumber,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\GetDocumentQuery $invoiceNumber
     */
    public function __construct($invoiceNumber)
    {
        $this->invoiceNumber = $invoiceNumber;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\GetDocumentQuery
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\GetDocumentQuery $invoiceNumber
     * @return GetDocument
     */
    public function withInvoiceNumber($invoiceNumber)
    {
        $new = clone $this;
        $new->invoiceNumber = $invoiceNumber;

        return $new;
    }
}
