<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetDocumentQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $InvoiceNumber;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'InvoiceNumber' => $this->InvoiceNumber,
        ];
    }

    /**
     * Constructor
     *
     * @var string $InvoiceNumber
     */
    public function __construct($InvoiceNumber)
    {
        $this->InvoiceNumber = $InvoiceNumber;
    }

    /**
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }

    /**
     * @param string $InvoiceNumber
     * @return GetDocumentQuery
     */
    public function withInvoiceNumber($InvoiceNumber)
    {
        $new = clone $this;
        $new->InvoiceNumber = $InvoiceNumber;

        return $new;
    }
}
