<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetInvoiceDetailsQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $InvoiceNumber;

    /**
     * @var bool
     */
    private $IsFromOldNavision;

    /**
     * @var string
     */
    private $OldCustomerNumber;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Division'          => $this->Division,
            'InvoiceNumber'     => $this->InvoiceNumber,
            'IsFromOldNavision' => $this->IsFromOldNavision,
            'OldCustomerNumber' => $this->OldCustomerNumber,
        ];
    }

    /**
     * Constructor
     *
     * @var string $Division
     * @var string $InvoiceNumber
     * @var bool $IsFromOldNavision
     * @var string $OldCustomerNumber
     */
    public function __construct($Division, $InvoiceNumber, $IsFromOldNavision, $OldCustomerNumber)
    {
        $this->Division = $Division;
        $this->InvoiceNumber = $InvoiceNumber;
        $this->IsFromOldNavision = $IsFromOldNavision;
        $this->OldCustomerNumber = $OldCustomerNumber;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return GetInvoiceDetailsQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }

    /**
     * @param string $InvoiceNumber
     * @return GetInvoiceDetailsQuery
     */
    public function withInvoiceNumber($InvoiceNumber)
    {
        $new = clone $this;
        $new->InvoiceNumber = $InvoiceNumber;

        return $new;
    }

    /**
     * @return bool
     */
    public function getIsFromOldNavision()
    {
        return $this->IsFromOldNavision;
    }

    /**
     * @param bool $IsFromOldNavision
     * @return GetInvoiceDetailsQuery
     */
    public function withIsFromOldNavision($IsFromOldNavision)
    {
        $new = clone $this;
        $new->IsFromOldNavision = $IsFromOldNavision;

        return $new;
    }

    /**
     * @return string
     */
    public function getOldCustomerNumber()
    {
        return $this->OldCustomerNumber;
    }

    /**
     * @param string $OldCustomerNumber
     * @return GetInvoiceDetailsQuery
     */
    public function withOldCustomerNumber($OldCustomerNumber)
    {
        $new = clone $this;
        $new->OldCustomerNumber = $OldCustomerNumber;

        return $new;
    }
}
