<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetMaterialItemQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $Division;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Division' => $this->Division,
        ];
    }

    /**
     * Constructor
     *
     * @var string $Division
     */
    public function __construct($Division)
    {
        $this->Division = $Division;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return GetMaterialItemQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }
}
